/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.sysutils;

import filenet.vw.sysutils.UTFBOMHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;

public class VWPropertyReader {
    private static final int CHARNONE = 0;
    private static final int CHARSLASH = 1;
    private static final int CHARUNICODE = 2;
    private static final int CHARCONTINUE = 3;
    private static final int CHARKEY_DONE = 4;
    private static final int CHARIGNORE = 5;

    public static Properties load(File file) throws IOException {
        if (UTFBOMHandler.isBOMPresent(file)) {
            UTFBOMHandler.removeBOMandWriteToFile(file);
        }
        Properties prop = VWPropertyReader.load(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), "UTF8"));
        return prop;
    }

    private static Properties load(Reader reader) throws IOException {
        int charmode = 0;
        int unicode = 0;
        int count = 0;
        char[] buf = new char[40];
        int offset = 0;
        int propkeyLength = -1;
        boolean firstChar = true;
        char[] inbuf = new char[256];
        int inbufCount = 0;
        int inbufPos = 0;
        Properties prop = new Properties();
        block17: while (true) {
            if (inbufPos == inbufCount) {
                inbufCount = reader.read(inbuf);
                if (inbufCount == -1) break;
                inbufPos = 0;
            }
            int nextChar = inbuf[inbufPos++];
            if (offset == buf.length) {
                char[] newBuf = new char[buf.length * 2];
                System.arraycopy(buf, 0, newBuf, 0, offset);
                buf = newBuf;
            }
            if (charmode == 2) {
                int digit = Character.digit((char)nextChar, 16);
                if (digit >= 0) {
                    unicode = (unicode << 4) + digit;
                    if (++count < 4) {
                        continue;
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                charmode = 0;
                buf[offset++] = (char)unicode;
                if (nextChar != 10) continue;
            }
            if (charmode == 1) {
                charmode = 0;
                switch (nextChar) {
                    case 13: {
                        charmode = 3;
                        continue block17;
                    }
                    case 10: {
                        charmode = 5;
                        continue block17;
                    }
                    case 98: {
                        nextChar = 8;
                        break;
                    }
                    case 102: {
                        nextChar = 12;
                        break;
                    }
                    case 110: {
                        nextChar = 10;
                        break;
                    }
                    case 114: {
                        nextChar = 13;
                        break;
                    }
                    case 116: {
                        nextChar = 9;
                        break;
                    }
                    case 117: {
                        charmode = 2;
                        count = 0;
                        unicode = 0;
                        continue block17;
                    }
                }
            } else {
                switch (nextChar) {
                    case 33: 
                    case 35: {
                        if (!firstChar) break;
                        do {
                            if (inbufPos != inbufCount) continue;
                            inbufCount = reader.read(inbuf);
                            if (inbufCount == -1) {
                                inbufPos = -1;
                                continue block17;
                            }
                            inbufPos = 0;
                        } while ((nextChar = inbuf[inbufPos++]) != 13 && nextChar != 10);
                        continue block17;
                    }
                    case 10: {
                        if (charmode == 3) {
                            charmode = 5;
                            continue block17;
                        }
                    }
                    case 13: {
                        charmode = 0;
                        firstChar = true;
                        if (offset > 0) {
                            if (propkeyLength == -1) {
                                propkeyLength = offset;
                            }
                            String temp = new String(buf, 0, offset);
                            prop.put(temp.substring(0, propkeyLength), temp.substring(propkeyLength));
                        }
                        propkeyLength = -1;
                        offset = 0;
                        continue block17;
                    }
                    case 92: {
                        if (charmode == 4) {
                            propkeyLength = offset;
                        }
                        charmode = 1;
                        continue block17;
                    }
                    case 58: 
                    case 61: {
                        if (propkeyLength != -1) break;
                        charmode = 0;
                        propkeyLength = offset;
                        continue block17;
                    }
                }
                if (Character.isWhitespace((char)nextChar)) {
                    if (charmode == 3) {
                        charmode = 5;
                    }
                    if (offset == 0 || offset == propkeyLength || charmode == 5) continue;
                    if (propkeyLength == -1) {
                        charmode = 4;
                        continue;
                    }
                }
                if (charmode == 5 || charmode == 3) {
                    charmode = 0;
                }
            }
            firstChar = false;
            if (charmode == 4) {
                propkeyLength = offset;
                charmode = 0;
            }
            buf[offset++] = nextChar;
        }
        if (propkeyLength == -1 && offset > 0) {
            propkeyLength = offset;
        }
        if (propkeyLength >= 0) {
            String temp = new String(buf, 0, offset);
            prop.put(temp.substring(0, propkeyLength), temp.substring(propkeyLength));
        }
        return prop;
    }
}

